#ifndef GST_COLOR_MAP_DESC_HPP__
#define GST_COLOR_MAP_DESC_HPP__

#include "buildspec.h"

#include "Client/ClientUtils/Network/ColorMap.hpp"
#include "Client/ClientUtils/Network/SimplexPropertyDesc.h"
#include "Utils/Converter.h"

#include <boost/shared_ptr.hpp>

#include <string>
#include <vector>

namespace GST
{
namespace ClientUtils
{
class GST_API_EXPORT ColorMapDesc
{
public:
	ColorMapDesc(const std::string &mapName,
				 const ColorMap::Id &mapId,
				 const std::string &regex,
				 long accessLevelId,
				 bool nodataTransparentForGrids = false,
				 ColorMapType type = ColorMapType::Continuous,
				 int64_t updated_at = -1);
	std::string GetName() const;
	ColorMap::Id GetId() const;
	std::string GetRegex() const;
	long GetAccessLevelId() const;
	ColorMapType GetType() const;
	bool IsNodataTransparentForGrids() const;
	/**
	 * tells you when the color map has been updated in a unix time stamp
	 * in seconds since epoch (1970-01-01)
	 */
	int64_t GetUpdatedAt() const;
	bool Matches(const SimplexPropertyDesc &desc) const;
	SimplexPropertyDescPtr GetMatched(
		const SimplexPropertyDescList &list) const;

private:
	std::string m_name;
	ColorMap::Id m_id;
	Utils::WildcardExpressionComparer m_wildCardExpressionComparer;
	long m_accessLevelId;
	ColorMapType m_type;
	bool m_nodataTransparentForGrids;
	// unix time stamp (seconds since epoch)
	int64_t m_updated_at;
};
typedef boost::shared_ptr<ColorMapDesc> ColorMapDescPtr;
typedef std::vector<ColorMapDescPtr> ColorMapDescList;
typedef boost::shared_ptr<ColorMapDescList> ColorMapDescListPtr;
} // namespace ClientUtils
} // namespace GST

#endif // GST_COLOR_MAP_DESC_HPP__
